﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections;

namespace StudyScores
{
    /// <summary>
    /// Contains sorting methods, including a stable support (Array.Sort in .NET is unstable).
    /// </summary>
    static class Sorting
    {

        #region Student Sorting Methods

        /// <summary>
        /// Sorts according to raw scores - highest first.
        /// </summary>
        public static int StudentHighScoreCompareRaw(Student student1, Student student2)
        {
            int[] scores1 = student1.GetRawScoreCounts();
            int[] scores2 = student2.GetRawScoreCounts();

            // check each score level for an imbalance (descending)
            for (int i = scores1.Length - 1; i >= 0; i--)
            {
                if (scores1[i] > scores2[i]) return -1;
                else if (scores1[i] < scores2[i]) return 1;
            }

            // sort by name if this fails
            return student1.Name.CompareTo(student2.Name);
        }

        /// <summary>
        /// Sorts according to scaled scores - highest first.
        /// </summary>
        public static int StudentHighScoreCompareScaled(Student student1, Student student2)
        {
            double[] scores1 = student1.GetScaledScoresInDescendingOrder();
            double[] scores2 = student2.GetScaledScoresInDescendingOrder();

            // check each score level for an imbalance (descending)
            for (int i = 0; i < scores1.Length; i++)
            {
                if (i > scores2.Length - 1 || scores1[i] > scores2[i]) return -1;
                else if (i > scores1.Length - 1 || scores1[i] < scores2[i]) return 1;
            }

            // sort by name if this fails
            return student1.Name.CompareTo(student2.Name);
        }

        /// <summary>
        /// Sorts according to sum of raw scores.
        /// </summary>
        public static int StudentTotalScoreCompareRaw(Student student1, Student student2)
        {
            if (student1.ScoreSum > student2.ScoreSum)
                return -1;
            if (student1.ScoreSum < student2.ScoreSum)
                return 1;
            else
                // equal in sum and order - sort by name
                return student1.Name.CompareTo(student2.Name);
        }

        /// <summary>
        /// Sorts according to sum of scaled scores.
        /// </summary>
        public static int StudentTotalScoreCompareScaled(Student student1, Student student2)
        {
            if (student1.ScaledScoreSum > student2.ScaledScoreSum)
                return -1;
            if (student1.ScaledScoreSum < student2.ScaledScoreSum)
                return 1;
            else
            {
                int highsortresult = StudentHighScoreCompareScaled(student1, student2);
                if (highsortresult != 0) return highsortresult;

                // equal in sum and order - sort by name
                return student1.Name.CompareTo(student2.Name);
            }
        }

        #endregion



        #region School Score Count Sorting Methods

        /// <summary>
        /// Sorts according to raw scores - highest first.
        /// </summary>
        public static int SchoolScoreCountHighCompareRaw(School school1, School school2)
        {
            int[] scores1 = school1.ScoreCounts;
            int[] scores2 = school2.ScoreCounts;

            // check each score level for an imbalance (descending)
            for (int i = scores1.Length - 1; i >= 0; i--)
            {
                if (scores1[i] > scores2[i]) return -1;
                else if (scores1[i] < scores2[i]) return 1;
            }

            // sort by name if this fails
            return school1.Name.CompareTo(school2.Name);
        }

        /// <summary>
        /// Sorts according to scaled scores - highest first.
        /// </summary>
        public static int SchoolScoreCountHighCompareScaled(School school1, School school2)
        {
            int[] scores1 = school1.ScaledScoreCounts;
            int[] scores2 = school2.ScaledScoreCounts;

            // check each score level for an imbalance (descending)
            for (int i = scores1.Length - 1; i >= 0; i--)
            {
                if (scores1[i] > scores2[i]) return -1;
                else if (scores1[i] < scores2[i]) return 1;
            }

            // sort by name if this fails
            return school1.Name.CompareTo(school2.Name);
        }

        /// <summary>
        /// Sorts according to sum of raw scores.
        /// </summary>
        public static int SchoolScoreCountTotalCompareRaw(School school1, School school2)
        {
            if (school1.ScoreSum > school2.ScoreSum)
                return -1;
            if (school1.ScoreSum < school2.ScoreSum)
                return 1;
            else
                return school1.Name.CompareTo(school2.Name);
        }

        /// <summary>
        /// Sorts according to sum of scaled scores.
        /// </summary>
        public static int SchoolScoreCountTotalCompareScaled(School school1, School school2)
        {
            if (school1.ScaledScoreSum > school2.ScaledScoreSum)
                return -1;
            if (school1.ScaledScoreSum < school2.ScaledScoreSum)
                return 1;
            else
                return school1.Name.CompareTo(school2.Name);
        }

        #endregion

    }
}
